package com.tll.inspect.rpc.vo.travel;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;

import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * title:
 * author: zq
 * create: 2025-06-10 14:59
 **/

@Data
@ApiModel(description = "行程详情rpc出参")
public class TravelDetailRpcVO {

    @ApiModelProperty("行程Id")
    private Long travelId;

    @ApiModelProperty("员工id")
    private Long userId;

    @ApiModelProperty("行程日期")
    private String travelDate;

    @ApiModelProperty("门店编码")
    private String storeCode;

    @ApiModelProperty("门店名称")
    private String storeName;

    @ApiModelProperty("行程类型（0其他 1赶路 2返程 3活动到店 4门店巡检 5休假")
    private String travelType;

    @ApiModelProperty("开始时间")
    private LocalDate startTime;

    @ApiModelProperty("结束时间")
    private LocalDate endTime;

    @ApiModelProperty("出发省编码")
    private String fromProvinceCode;

    @ApiModelProperty("出发省名称")
    private String fromProvinceName;

    @ApiModelProperty("出发市编码")
    private String fromCityCode;

    @ApiModelProperty("出发市名称")
    private String fromCityName;

    @ApiModelProperty(value = "目的地省编码")
    private String toProvinceCode;

    @ApiModelProperty(value = "目的地省名称")
    private String toProvinceName;

    @ApiModelProperty("目的地市编码")
    private String toCityCode;

    @ApiModelProperty("目的地市名称")
    private String toCityName;

    @ApiModelProperty("具体明细")
    private String detail;

    @ApiModelProperty("行程说明")
    private String description;

    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

}