package com.tll.inspect.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.tll.inspect.Application;
import com.tll.inspect.rpc.dto.library.PictureLibraryRpcDTO;
import com.tll.inspect.rpc.vo.library.PictureLibraryRpcVO;
import com.tll.inspect.rpc.vo.library.UploadListRpcVO;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;


/**
 * 巡检图库rpc服务类
 */
@FeignClient(name = Application.NAME, path = PictureLibraryRpcService.URI)
@Validated
public interface PictureLibraryRpcService {

    String URI = Application.URI_PREFIX + "/pictureLibrary";


    @ApiOperation(value = "新增巡检图库")
    @PostMapping("/create")
    ApiResult<PictureLibraryRpcVO> create(@RequestBody PictureLibraryRpcDTO dto);

    @ApiOperation(value = "id更新图库状态、上传路径")
    @PostMapping("/updateStatusById")
    void updateStatusById(@RequestBody PictureLibraryRpcDTO dto);

    @ApiOperation(value = "查询图库上传列表")
    @PostMapping("/queryUploadList")
    ApiResult<UploadListRpcVO> queryUploadList(@RequestBody PictureLibraryRpcDTO dto);

    @ApiOperation(value = "查询图库列表")
    @PostMapping("/queryList")
    ApiResult<List<PictureLibraryRpcVO>> queryList(@RequestBody PictureLibraryRpcDTO dto);

    @ApiOperation(value = "删除图片")
    @PostMapping("/delete")
    void delete(@RequestBody PictureLibraryRpcDTO rpcDTO);


}