package com.tll.inspect.rpc.dto;

import com.tll.inspect.rpc.dto.media.MediaDTO;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;


/**
 * @author XieBeiChen
 * @date 2025-06-12 13:44
 * @description
 */
@NoArgsConstructor
@AllArgsConstructor
@Data
public class ReportSaveDraftDTO implements Serializable {

    @ApiModelProperty(value = "报告id",required = true)
    @NotNull(message = "报告id不能为空")
    private Long reportId;

    @ApiModelProperty("报告项")
    private List<Items> items;

    @ApiModelProperty("表单内容")
    private List<OptionCommitDTO> forms;

    @ApiModelProperty("整改到期时间")
    private LocalDateTime dueTime;

    @ApiModelProperty(value = "报告总结")
    private String reportSummary;

    @ApiModelProperty("是否是确认页保存草稿")
    private Boolean confirmFlag;

    @NoArgsConstructor
    @AllArgsConstructor
    @Data
    public static class Items  implements Serializable {

        @NotNull(message = "巡检项id不能为空")
        @ApiModelProperty(value = "巡检项id",required = true)
        private Long itemId;

        @ApiModelProperty(value = "是否合格（1-合格，0-不合格）", required = true)
        @NotNull(message = "是否合格不能为空")
        private Boolean passFlag;

        @NotBlank(message = "原因必填")
        @ApiModelProperty(value = "原因",required = true)
        private String reason;

        @ApiModelProperty(value = "是否现场整改（1-是，0-否）",required = true)
        private Boolean rectifiedOnSite;

        @ApiModelProperty("整改说明")
        private String rectifiedRemark;

        @ApiModelProperty(value = "巡检现场照片或者视频，可选",required = true)
        private List<MediaDTO> fileUrls;

        @ApiModelProperty("整改图片")
        private List<MediaDTO> rectifiedFileUrls;
    }




}
