package com.tll.inspect.rpc.dto.signin;

import com.tll.inspect.rpc.dto.media.MediaDTO;
import io.swagger.annotations.ApiModelProperty;

import java.time.LocalDateTime;
import java.util.List;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author XieBeiChen
 * @date 2025-06-04 14:43
 * @description
 */
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Data
public class SignInAddDTO {

    @ApiModelProperty(value = "定位地址，例如“北京市海淀区xxx”")
    private String location;

    @ApiModelProperty(value = "巡检任务编码")
    private String inspectTaskNumber;

    @ApiModelProperty(value = "巡检任务id")
    private Long travelId;

    @ApiModelProperty(value = "经度")
    private Double longitude;

    @ApiModelProperty(value = "纬度")
    private Double latitude;

    @ApiModelProperty(value = "距离，单位米")
    private Integer distance;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "巡检现场照片或者视频，可选")
    private List<Media> fileUrls;

    @ApiModelProperty("设备码")
    private String deviceCode;

    @NoArgsConstructor
    @AllArgsConstructor
    @Data
    public static class Media {
        @ApiModelProperty("文件类型:0-图片,1-视频")
        private Integer fileType;

        @ApiModelProperty("链接")
        private String url;

        @ApiModelProperty("文件名")
        private String fileName;
    }

    @ApiModelProperty("申诉附件列表")
    private List<MediaDTO> appealFiles;

    @ApiModelProperty("门店编码")
    private String storeCode;

    @ApiModelProperty("打卡数据来源:1-打卡，2-到店签到，3-离店签退")
    private Integer source;

    @ApiModelProperty("是否强制签退")
    private Boolean forceSignOut = false;

    @ApiModelProperty("强制签退时实际离店时间")
    private LocalDateTime actualLeaveTime;
}
