package com.tll.inspect.rpc.dto.travel;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 行程门店 保存参数
 *
 * @author zhaoshuai
 * @date 2025/6/4
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class TravelStoreRpcDTO {

    @ApiModelProperty("行程门店id")
    private Long storeId;

    @ApiModelProperty("门店编码")
    private String storeCode;

    @ApiModelProperty(value = "渠道：1-普通门店添加 2-交叉巡检门店添加")
    private Integer channel;
    
    @ApiModelProperty("巡检计划id")
    private Long planId;
}
