package com.tll.inspect.rpc.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 行程提交审核响应
 * @author zhaoshuai
 * @date 2025/8/5
 */
@Data
@ApiModel("行程提交审核响应")
public class TravelChangeSubmitRpcVO implements Serializable {

    private static final long serialVersionUID = -6434395018171355753L;


    private Integer errorCode;

    private String errorMessage;
    /**
     * 行程执行人员工id
     */
    @ApiModelProperty(value = "行程执行人员工id")
    private Long travelExecuteUserId;

    /**
     * 行程执行人姓名
     */
    @ApiModelProperty(value = "行程执行人姓名")
    private String travelExecuteUserName;

    /**
     * 行程执行日期
     */
    @ApiModelProperty(value = "行程执行日期")
    private String travelDate;

    /**
     * 行程类型名称
     */
    @ApiModelProperty(value = "行程类型名称")
    private String travelTypeName;

    /**
     * 行程审核记录id
     */
    @ApiModelProperty(value = "行程审核记录id")
    private String auditLogId;

    /**
     * 已存在行程id
     */
    @ApiModelProperty("已存在行程id")
    private Long existTravelId;

}
