package com.tll.inspect.rpc.vo.report;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 巡检报告列表返回
 *
 * @author zhaoshuai
 * @date 2025/6/18
 */
@NoArgsConstructor
@AllArgsConstructor
@Data
@ApiModel(description = "巡检报告列表返回")
public class InspectReportListRpcVO implements Serializable {

    private static final long serialVersionUID = 6703750361830199160L;

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("行程Id")
    private Long travelId;

    @ApiModelProperty("巡检任务编号")
    private String inspectTaskNumber;

    @ApiModelProperty("门店编号")
    private String storeCode;

    @ApiModelProperty("巡检人")
    private String executor;
    @ApiModelProperty("巡检人岗位名称")
    private String executeUserPositionName;

    @ApiModelProperty("模板编号")
    private Long templateId;

    @ApiModelProperty("模板名称")
    private String templateName;

    @ApiModelProperty("模板描述")
    private String templateDesc;

    @ApiModelProperty("状态（1-草稿，2-已提交）")
    private Integer status;

    @ApiModelProperty("是否合格（1-合格，0-不合格）")
    private Boolean passFlag;

    @ApiModelProperty("关联表单id")
    private String formId;

    @ApiModelProperty("关联表单名称")
    private String formName;

    @ApiModelProperty("整改状态（0=无需整改，1=整改中，2=已完成）")
    private Integer rectificationStatus;

    @ApiModelProperty("巡检报告得分")
    private BigDecimal score;

    @ApiModelProperty(value = "模版合格分数")
    private BigDecimal passScore;

    @ApiModelProperty(value = "模板分数")
    private BigDecimal templateScore;

    @ApiModelProperty(value = "巡检总分（包含加分项、减分项）")
    private BigDecimal totalScore;

    @ApiModelProperty("报告提交时间")
    private LocalDateTime commitTime;

    @ApiModelProperty(value = "巡检项合格率")
    private double passRate=0.0;

    @ApiModelProperty(value = "整改问题数")
    private int rectificationTotal=0;

    @ApiModelProperty(value = "整改率")
    private double rectificationRate=0.0;

    @ApiModelProperty(value = "门店名称")
    private String storeName;

    @ApiModelProperty(value = "法人姓名")
    private String legalPerson;

}
