package com.tll.inspect.rpc.vo.signin;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author XieBeiChen
 * @date 2025-06-04 13:52
 * @description
 */
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Data
public class SignInListVO implements Serializable {

    private Long id;

    @ApiModelProperty("打卡数据来源:1-打卡，2-到店签到，3-离店签退")
    private Integer source;

    @NotBlank(message = "定位地址不能为空")
    private String location;

    @ApiModelProperty(value = "经度",required = true)
    private Double longitude;

    @ApiModelProperty(value = "纬度",required = true)
    private Double latitude;

    @ApiModelProperty(value = "距离，单位米",required = true)
    private Integer distance;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "巡检现场照片或者视频，可选")
    private List<Media> fileUrls;

    @ApiModelProperty("设备码")
    private String deviceCode;

    @ApiModelProperty("签到时间")
    private LocalDateTime createTime;

    @NoArgsConstructor
    @AllArgsConstructor
    @Data
    public static class Media {
        @ApiModelProperty("文件类型:0-图片,1-视频")
        private Integer fileType;

        @ApiModelProperty("链接")
        private String url;
    }
}
