package com.tll.inspect.rpc.dto.travel;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;

/**
 * 行程拓展信息
 *
 * @author zhaoshuai
 * @date 2025/6/7
 */
@NoArgsConstructor
@AllArgsConstructor
@Data
public class TravelExtraRpcDTO {

    @ApiModelProperty("行程id")
    private Long travelId;

    @ApiModelProperty("请假单id")
    private String vacationId;

    @ApiModelProperty("行程日期（yyyy-MM-dd）")
    private String travelDate;

    @ApiModelProperty("日期范围类型(0全天 1上半天 2 下半天)")
    private Integer dateRangeType ;

    @ApiModelProperty("自定义巡检行程开始时间")
    private String customerStartTime;

    @ApiModelProperty(value = "开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm")
    private LocalDateTime startTime;

    @ApiModelProperty("结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm")
    private LocalDateTime endTime;

    @ApiModelProperty(value = "出发省编码")
    private String fromProvinceCode;

    @ApiModelProperty(value = "出发省名称")
    private String fromProvinceName;

    @ApiModelProperty("出发市编码")
    private String fromCityCode;

    @ApiModelProperty("出发市名称")
    private String fromCityName;

    @ApiModelProperty(value = "目的地省编码")
    private String toProvinceCode;

    @ApiModelProperty(value = "目的地省名称")
    private String toProvinceName;

    @ApiModelProperty("目的地市编码")
    private String toCityCode;

    @ApiModelProperty("目的地市名称")
    private String toCityName;

    @ApiModelProperty("具体明细")
    private String detail;

    @ApiModelProperty("行程说明")
    private String description;

}
