package com.tll.inspect.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.tll.inspect.Application;
import com.tll.inspect.rpc.dto.travel.*;
import com.tll.inspect.rpc.vo.TravelChangeSubmitRpcVO;
import com.tll.inspect.rpc.vo.travel.*;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;
import java.util.List;
import java.util.Map;

/**
 * title:
 * author: zq
 * create: 2025-06-10 13:55
 **/

@FeignClient(name = Application.NAME, path = TravelRpcService.URI)
@Validated
public interface TravelRpcService {

    String URI = Application.URI_PREFIX + "/travel";


    @ApiOperation(value = "查询执行人行程列表")
    @PostMapping("/queryUserTravelList")
    ApiResult<UserTravelListRpcVO> queryTravelList(@RequestBody UserTravelListRpcDTO dto);


    @PostMapping("/findStoreList")
    @ApiOperation("查询行程门店列表")
    ApiResult<PagingVO<StoreInfoRpcVO>> findStoreList(@RequestBody StoreListQueryRpcDTO queryDTO);

    @PostMapping("/findCrossStoreList")
    @ApiOperation("查询行程门店列表")
    ApiResult<PagingVO<CrossStoreInfoRpcVO>> findCrossStoreList(@RequestBody CrossStoreListQueryRpcDTO queryDTO);

    @PostMapping("/findExecutorList")
    @ApiOperation("查询行程执行人列表")
    ApiResult<PagingVO<ExecutorRpcVO>> findExecutorList(@RequestBody ExecutorListQueryRpcDTO dto);

    @PostMapping("/create")
    @ApiOperation("新增行程")
    ApiResult<TravelChangeSubmitRpcVO> create(@RequestBody @Validated TravelUpdateSubmitRpcDTO dto);

//    @PostMapping("/update")
//    @ApiOperation("编辑行程")
//    ApiResult<Object> update(@RequestBody @Validated TravelUpdateSubmitRpcDTO dto);

    @PostMapping("/querySelfTravelPage")
    @ApiOperation("我的行程（单人行程明细）（C端）")
    ApiResult<Map<String, List<TravelRpcVO>>> querySelfTravelPage(@RequestBody TravelListQueryRpcDTO dto);

    @PostMapping("/queryTravelPage")
    @ApiOperation("行程列表（权限下多人的行程列表）（C端）")
    ApiResult<PagingVO<ExecutorRpcVO>> queryTravelPage(@RequestBody TravelListQueryRpcDTO dto);

    @PostMapping("/queryTravelDetail")
    @ApiOperation("行程详情（C端）")
    ApiResult<TravelRpcVO> queryTravelDetail(@RequestBody TravelListQueryRpcDTO dto);

    @PostMapping("/queryTravelChangeDetail")
    @ApiOperation("行程详情（C端）")
    ApiResult<TravelRpcVO> queryTravelChangeDetail(@Valid @RequestBody TravelChangeQueryRpcDTO dto);

    @PostMapping("/delete")
    @ApiOperation("删除行程（C端）")
    ApiResult<String> delete(@RequestBody TravelListQueryRpcDTO dto);
}