package com.tll.inspect.rpc.dto.travel;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * 行程 保存参数
 *
 * @author zhaoshuai
 * @date 2025/6/4
 */
@NoArgsConstructor
@AllArgsConstructor
@Data
public class TravelUpdateSubmitRpcDTO {

    @ApiModelProperty("行程id")
    private Long id;

    @ApiModelProperty(value = "行程类型（0其他 1赶路 2返程 3活动到店 4门店巡检）", required = true)
    private Integer travelType;

    @ApiModelProperty(value = "行程执行人id", required = true)
    private Long executeUserId;
    @ApiModelProperty(value = "行程执行人姓名", required = true)
    private String executeUserName;
    @ApiModelProperty(value = "执行人岗位名称", required = true)
    private String executeUserPositionName;

    @ApiModelProperty(value = "执行人部门id（全路径）")
    private String executeUserDeptId;
    @ApiModelProperty(value = "执行人部门名称（全路径）")
    private String executeUserDeptName;

    @ApiModelProperty(value = "行程拓展信息", required = true)
    private TravelExtraRpcDTO extra;

    @ApiModelProperty(value = "行程门店", required = false)
    private List<TravelStoreRpcDTO> travelStores;

    @ApiModelProperty(value = "审核提交备注", required = true)
    private String auditDescription;

    @ApiModelProperty("是否需要审核")
    private Boolean needAudit;

}
