package com.tll.inspect.rpc.vo.report;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * 巡检报告详情返回
 * @author zhaoshuai
 * @date 2025/6/18
 */
@NoArgsConstructor
@AllArgsConstructor
@Data
@ApiModel(description = "巡检报告详情返回")
public class InspectReportDetailRpcVO implements Serializable {

    @ApiModelProperty("巡检报告id")
    private Long id;

    @ApiModelProperty("是否展示图文模式入口：0-否，1-是")
    private Integer showPicMode;

    @ApiModelProperty("详情页模块分组列表")
    private List<InspectReportDetailModuleVO> modules;

    @ApiModelProperty("图文模式-巡检报告项详情")
    private List<InspectReportDetailItemVO> picModuleItems;


}
