package com.tll.inspect.constant;

import lombok.Getter;

/**
 * 巡检操作内容类型
 */
@Getter
public enum OperateTypeRpcEnum {

    CREATE(0,"新建"),
    MODIFY(1,"编辑"),
    MOVE(2,"移动"),
    ENABLE(3,"启用"),
    DISABLE(4,"禁用"),
    COPY(5,"复制"),
    DELETE(6,"删除"),
    TRANSFER(7,"移交"),
    SUBMIT(9,"提交"),
    REMIND(10,"提醒"),
    FILTER(11,"过滤");

    // 0新建 1编辑 2移动 3启用 4禁用 5复制 6删除 7移交 8复核 9提交,10提醒

    private Integer code;

    private String desc;

    OperateTypeRpcEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
    public static OperateTypeRpcEnum getByCode(Integer code) {
        for (OperateTypeRpcEnum statusEnum : values()) {
            if (statusEnum.getCode().equals(code)) {
                return statusEnum;
            }
        }
        return null;
    }
}
