package com.tll.inspect.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.tll.inspect.Application;
import com.tll.inspect.rpc.dto.inspectTask.InspectTaskRevokeRpcDTO;
import com.tll.inspect.rpc.vo.UnifiedReturnRpcVO;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;

/**
 * 巡检任务Rpc接口
 *
 * @author Jxinx
 * @since 2025-09-26
 */
@FeignClient(name = Application.NAME, path = InspectTaskRpcService.URI)
public interface InspectTaskRpcService {

    String URI = Application.URI_PREFIX + "/api/inspectTask";

    @PostMapping(value = "/revoke")
    @ApiOperation(value = "巡检撤销")
    ApiResult<UnifiedReturnRpcVO> revoke(@RequestBody @Valid InspectTaskRevokeRpcDTO updateDTO);
}
