package com.tll.inspect.rpc.dto;

import com.elitescloud.boot.excel.common.param.AbstractExportQueryParam;
import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import javax.persistence.Column;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;


/**
 * @author  XieBeiChen
 * @date  2025-06-12 13:44
 * @description
 */
@NoArgsConstructor
@AllArgsConstructor
@Data
public class ReportTemplateItemPageDTO extends AbstractExportQueryParam implements Serializable {

    @ApiModelProperty(value = "报告id",required = true)
    @NotNull(message = "报告id不能为空")
    private Long reportId;

    @ApiModelProperty("仅看未完成项")
    private Boolean onlyUnFinish;

    @ApiModelProperty("是否合格（1-合格，0-不合格）")
    private Boolean passFlag;

    @ApiModelProperty("巡检模块名称")
    private String itemModule;

    @ApiModelProperty("模块id")
    private Long itemModuleId;
}
