package com.tll.inspect.rpc.dto.inspectTask;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 巡检任务撤销请求实体类
 *
 * @author Jxinx
 * @since 2025-09-26
 */
@Data
@ApiModel(description = "巡检任务撤销请求实体类")
public class InspectTaskRevokeRpcDTO implements Serializable {

    private static final long serialVersionUID = -4329229707794337857L;

    @NotBlank(message = "巡检任务编号不能为空")
    @ApiModelProperty("巡检任务编号")
    private String inspectTaskNumber;

    @NotBlank(message = "撤销原因不能为空")
    @ApiModelProperty("撤销原因")
    private String revokeRemark;

}