package com.tll.inspect.constant;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author zhaoshuai
 * @date 2025-06-17
 * @description 巡检图库类型
 */
@Getter
@AllArgsConstructor
public enum PictureLibraryTypeEnum {

    REPORT(0, "巡检报告"),
    REPAIR(1, "整改单");

    private final Integer code;
    private final String desc;

    /**
     * 根据编码获取描述
     * @param code 编码
     * @return 描述信息
     */
    public static String getDescByCode(Integer code) {
        for (PictureLibraryTypeEnum type : values()) {
            if (type.getCode().equals(code)) {
                return type.getDesc();
            }
        }
        return null;
    }
}
