package com.tll.inspect.rpc.vo.report;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 门店时间信息RPC VO
 * 返回门店最近一次巡检时间和报货时间
 *
 * @author auto-generated
 * @date 2025/01/XX
 */
@NoArgsConstructor
@AllArgsConstructor
@Data
@ApiModel(description = "门店时间信息返回")
public class StoreTimeRpcVO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "门店编码")
    private String storeCode;

    @ApiModelProperty(value = "最近一次巡检时间")
    private LocalDateTime lastInspectionTime;

    @ApiModelProperty(value = "最近一次巡检报告ID")
    private Long lastInspectionReportId;

    @ApiModelProperty(value = "最近一次报货时间")
    private String lastReportTime;

}

