package com.elitesland.inv.provider;


import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.inv.Application;
import com.elitesland.inv.dto.invAj.InvAjRpcDTO;
import com.elitesland.inv.dto.invAj.InvAjSaveRpcDTO;
import org.apache.kafka.clients.admin.internals.AdminApiHandler;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @author jeesie
 */
@Validated
@FeignClient(name = Application.NAME,path = Application.PATH + InvAjProvider.PATH)
public interface InvAjProvider {

    String PATH = "/invAj";

    /**
     * 返回单据号
     */
    @PostMapping("/saveConfirmAj")
    ApiResult<Long> saveAndConfirmAj(@RequestBody InvAjSaveRpcDTO saveRpcDTO);

    @PostMapping("/save")
    ApiResult<Long> save(@RequestBody InvAjSaveRpcDTO saveRpcDTO);


    @GetMapping("/getById")
    ApiResult<InvAjRpcDTO> getById(@RequestParam("id") Long id);

}
