package com.elitesland.inv.dto.invAsm;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author jeesie
 * @description:
 * @datetime 2025年 02月 24日 14:33
 * @version: 1.0
 */
@Data
@ApiModel(value = "StoreOrderBomAsmRpcDTO", description = "门店订单子件自动加工")
public class StoreOrderBomAsmRpcDTO implements Serializable {

    private static final long serialVersionUID = -1943495783422777456L;

    @ApiModelProperty("门店单据ID")
    private Long storeOrderId;

    @ApiModelProperty("门店单据单号")
    private String storeOrderNo;

    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;

    @ApiModelProperty("仓库名称")
    private String whCode;

    @ApiModelProperty("原因码 [UDC]COM:REASON_CODE")
    @SysCode(sys = "yst-supp", mod = "REASON_CODE")
    private String reasonCode;
    private String reasonCodeName;

    @ApiModelProperty("加工方式")
    private String processMethod;

    @ApiModelProperty("库区")
    private String deter2;

    @ApiModelProperty("是否子件加工")
    private Boolean isSubItemBom;

    @Data
    public static class StoreOrderBomItemDetail implements Serializable {

        private static final long serialVersionUID = 8564804230802160076L;
        @ApiModelProperty("品项ID")
        @JsonSerialize(using = ToStringSerializer.class)
        @NotNull
        private Long bomItemId;

        @ApiModelProperty("品项编码")
        @NotBlank
        private String bomItemCode;

        @ApiModelProperty("单位")
        @NotBlank(message = "单位不能为空")
        private String uom;

        @ApiModelProperty("组套主件ID")
        @JsonSerialize(using = ToStringSerializer.class)
        private Long bomPid;

        @ApiModelProperty("组套子件ID")
        @JsonSerialize(using = ToStringSerializer.class)
        private Long bomCid;

        @ApiModelProperty("组套比例")
        private BigDecimal preQty;

        @ApiModelProperty(value = "损耗率")
        private BigDecimal lossRate;

        @ApiModelProperty("加工数量")
        @NotNull
        private BigDecimal asmQty;

    }


}
