package com.elitesland.inv.dto.invAj;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author jeesie
 * @description:
 * @datetime 2023年 09月 01日 11:03
 * @version: 1.0
 */
@Data
@ApiModel(value = "InvAjDSaveRpcDTO", description = "库存调整保存明细")
public class InvAjdSaveRpcDTO implements Serializable {

    private static final long serialVersionUID = -2585004144033119183L;

    @ApiModelProperty("调整数量")
    private BigDecimal qty;

    @ApiModelProperty("单位")
    private String uom;

    @ApiModelProperty("调整数量(辅单位)")
    private BigDecimal qty2;

    @ApiModelProperty("辅单位")
    private String uom2;

    @ApiModelProperty("批次号,启用商品属性批次必须传")
    private String lotNo;

    @ApiModelProperty("生产日期")
    private LocalDateTime manuDate;

    @ApiModelProperty("商品编码")
    @NotBlank(message = "商品编码不能为空")
    private String itemCode;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("商品类型")
    private String itemype2;

    @ApiModelProperty("异构ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long variId;

    @ApiModelProperty("库存状态")
    private String limit1;

    @ApiModelProperty("限定2")
    private String limit2;

    @ApiModelProperty("限定3")
    private String limit3;

    @ApiModelProperty("来源订单明细行号")
    private Double sourceLineNo;

    @ApiModelProperty("来源订单明细ID")
    private Long sourceDocDid;


}
