package com.elitesland.inv.provider;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.inv.Application;
import com.elitesland.inv.dto.ido.InvIdoCancelParamRpcDTO;
import com.elitesland.inv.dto.ido.InvIdoRpcDto;
import com.elitesland.inv.dto.ido.InvIdoSaveRpcDTO;
import com.elitesland.inv.dto.odo.InvOdoSaveRpcDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Validated
@FeignClient(name = Application.NAME,path = Application.PATH + InvIdoProvider.PATH)
public interface InvIdoProvider {
    String PATH = "/invIdoProvider";

    /**
     * 创建入库单
     * 单据状态为草稿
     * @param invIdoSaveRpcDTO
     * @return 返回人库单ID
     */
    @PostMapping("/saveInvIdo")
    ApiResult<String> saveInvIdo(@Validated @RequestBody InvIdoSaveRpcDTO invIdoSaveRpcDTO);

    /**
     * 取消入库单
     * @param param
     * @return 返回出库单ID
     */
    @PostMapping("/cancelInvIdo")
    ApiResult<Long> cancelInvIdo(@RequestBody InvIdoCancelParamRpcDTO param);

    /**
     * 创建且确认入库单
     * @param invIdoSaveRpcDTO
     * @return 返回出库单ID
     */
    @PostMapping("/saveAndConfirmInvIdo")
    ApiResult<String> saveAndConfirmInvIdo(@Validated @RequestBody InvIdoSaveRpcDTO invIdoSaveRpcDTO);

    @GetMapping("getByDocNo")
    ApiResult<InvIdoRpcDto> getByDocNo(@RequestParam("docNo") String docNo);

    @GetMapping("getByRelateDocNo")
    ApiResult<InvIdoRpcDto> getByRelateDocNo(@RequestParam("relateDocNo") String relateDocNo);

}
