package com.elitesland.inv.openapi.param;

import lombok.Data;

import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * @author : chen.niu
 * @description : 入库商品信息
 * @date : 2025/10/28 13:51
 */
@Data
public class InvPurLdoConfirmSsLdoDtlParam {
  private Double lineNo; //必填	行号
  private String itemName; //必填 商品名称

  //唯一主键
  private String itemCode; //必填	商品编码
  private String lotNo; //必填	批次号
  private LocalDate wmsDate; //必填	入库日期 年月日 内部补零00:00:00
  private LocalDate manuDate;//非必填 生产日期 年月日 内部补零00:00:00    根据商品是否管理效期
  private LocalDate expireDate;//非必填 有效期至 年月日 内部补零00:00:00  非必填 根据商品是否管理效期
  private String productNo;//产品批号 非必填 商品是否管理批号
  private String manuFactory;//必填 生产厂家
  private String approvalNumber;//必填 批准文号

  private Double qty; //必填	收货数量 实际收货数据,WMS回传后,会进行收货单修改会重新
  private String uom; //必填	入库数基本单位
//  private String uom2; //非必填	入库数辅助单位
  private String spec;//必填 规格型号
  private String concSpec;//必填 浓度规格
  private String barcode;//必填 条码
  private String origin;//必填 产地
  private String dosageForm;//必填 剂型

  //验收参数 约束okQty+noQty+rejectQty=demandQty
  private Double okQty;//验收必填 合格数
  private Double noQty;//验收必填不合格数
  private Double rejectQty;//验收必填 拒收数
  private String rejectReason;//验收必填 拒收原因
  //  private String limit1; //	库存状态

}
