package com.elitesland.inv.openapi.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * @author : chen.niu
 * @description : 入库商品信息
 * @date : 2025/10/28 13:51
 */
@Data
@ApiModel(value = " InvPurLdoConfirmSsLdoDtlParam", description = "WMS入库确认商品信息")
public class InvPurLdoConfirmSsLdoDtlParam {

  @ApiModelProperty(value ="行号",required = true) private Double lineNo; //必填	行号
  @ApiModelProperty(value ="商品名称,required = true") private String itemName; //必填 商品名称

  //唯一主键
  @ApiModelProperty(value = "商品编码",required = true) private String itemCode; //必填	商品编码
  @ApiModelProperty(value="批次号",required = true) private String lotNo; //必填	批次号
  @ApiModelProperty(value="入库日期",required = true) private LocalDate wmsDate; //必填	入库日期 年月日 内部补零00:00:00
  @ApiModelProperty(value="生产日期",required = false) private LocalDate manuDate;//非必填 生产日期 年月日 内部补零00:00:00    根据商品是否管理效期
  @ApiModelProperty(value="有效期至",required = false) private LocalDate expireDate;//非必填 有效期至 年月日 内部补零00:00:00  非必填 根据商品是否管理效期
  @ApiModelProperty(value="产品批号",required = false) private String productNo;// 非必填 产品批号 商品是否管理批号
  @ApiModelProperty(value="生产厂家",required = true) private String manuFactory;//必填 生产厂家
  @ApiModelProperty(value="批准文号",required = true) private String approvalNumber;//必填 批准文号

  @ApiModelProperty(value="收货数量",required = true) private Double qty; //必填	收货数量 实际收货数据,WMS回传后,会进行收货单修改会重新
  @ApiModelProperty(value="入库数基本单位",required = true) private String uom; //必填	入库数基本单位
  @ApiModelProperty(value="规格型号",required = true) private String spec;//必填 规格型号
  @ApiModelProperty(value="浓度规格",required = true) private String concSpec;//必填 浓度规格
  @ApiModelProperty(value="条码",required = true) private String barcode;//必填 条码
  @ApiModelProperty(value="产地",required = true) private String origin;//必填 产地
  @ApiModelProperty(value="剂型",required = true) private String dosageForm;//必填 剂型
  //  private String uom2; //非必填	入库数辅助单位
  //验收参数 约束okQty+noQty+rejectQty=demandQty
  @ApiModelProperty(value="合格数",required = true) private Double okQty;//验收必填 合格数
  @ApiModelProperty(value="不合格数",required = true) private Double noQty;//验收必填 不合格数
  @ApiModelProperty(value="拒收数",required = true) private Double rejectQty;//验收必填 拒收数
  @ApiModelProperty(value="拒收原因",required = true) private String rejectReason;//验收必填 拒收原因
  //  private String limit1; //	库存状态

}
