package com.elitesland.inv.dto.invlot.resp;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author jeesie
 * @description:
 * @datetime 2023年 08月 18日 17:37
 * @version: 1.0
 */
@Data
public class InvLotCommonRpcDto implements Serializable {

    private static final long serialVersionUID = -8830403649281693691L;
    @ApiModelProperty("属性5")
    private String es1;

    @ApiModelProperty("属性6")
    private String es2;

    @ApiModelProperty("属性7")
    private String es3;

    @ApiModelProperty("属性8")
    private String es4;

    @ApiModelProperty("属性9")
    private String es5;

    @ApiModelProperty("属性10")
    private String es6;

    @ApiModelProperty("保质期天数")
    private Integer expireDays;

    @ApiModelProperty("生产日期")
    private LocalDateTime manuDate;

    @ApiModelProperty("失效日期")
    private LocalDateTime expireDate;

    @ApiModelProperty("新鲜度 每天自动计算。[UDC]COM:FRESS_TYPE")
    @SysCode(sys = "yst-supp",mod = "FRESS_TYPE")
    private String fressType;
    private String fressTypeName;

    @ApiModelProperty("批次ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long lotId;

    @ApiModelProperty("批号")
    private String lotNo;

    @ApiModelProperty("品项ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    @ApiModelProperty("品项编号")
    private String itemCode;

    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty("公司编码")
    @JsonSerialize(using = ToStringSerializer.class)
    private String ouCode;

    @ApiModelProperty("入库日期")
    private LocalDateTime stkInDate;

    @ApiModelProperty("项目编号")
    private String projectCode;

    @ApiModelProperty("项目名称")
    private String projectName;

    @ApiModelProperty("含税价")
    private BigDecimal price;

    @ApiModelProperty("未税价")
    private BigDecimal netPrice;

    @ApiModelProperty("生产厂家")
    private String manuFactory;
    @ApiModelProperty("生产厂家名")
    private String manuFactoryName;

    @ApiModelProperty("首次批次号")
    private String firstBatchNo;
    @ApiModelProperty("上游批次号")
    private String  upstreamBatchNo;
    @ApiModelProperty("首次入库价格")
    private BigDecimal firstIdoPrice;
    @ApiModelProperty("批次价格")
    private BigDecimal lotPrice;
    @ApiModelProperty("追溯序号")
    private Long traceabilityNumber;
    @ApiModelProperty(value = "产品批号")
    private String productNo;
}
