package com.elitesland.inv.dto.invIo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

@Data
@ApiModel("库存流水查询入参")
public class InvIoDateRangeParamRpcDTO implements Serializable {
    private static final long serialVersionUID = -8014753420118258628L;

    @ApiModelProperty("商品IDs")
    private List<Long> itemIds;

    @ApiModelProperty("公司ID")
    private Long ouId;

    @ApiModelProperty("仓库IDs")
    private List<Long> whIds;

    @ApiModelProperty("流水日期从")
    private LocalDateTime ioDateFrom;

    @ApiModelProperty("流水日期至")
    private LocalDateTime ioDateTo;

    @ApiModelProperty("场景码")
    private List<String> sceneCodes;

    private List<String> srcDocClsList;

}
