package com.elitesland.inv.dto.invstk;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.inv.util.BaseModelDTO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/03/28
 * @Version 1.0
 * @Content:
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "invIoFinReceiptRpcDTO", description = "查询逻辑性库存流水生成对应财务单据(应收单,应付单)RPC出参")
public class InvIoFinReceiptRpcDTO extends BaseModelDTO implements Serializable {
    private static final long serialVersionUID = 5323412514890795108L;

    @ApiModelProperty("库存流水id")
    private Long id;

    @ApiModelProperty("单据编号")
    private String docNo;

    @ApiModelProperty("公司id")
    private Long ouId;
    @ApiModelProperty("公司编码")
    private String ouCode;
    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("BUID")
    private Long buId;
    @ApiModelProperty("BU编码")
    private String buCode;
    @ApiModelProperty("BU名称")
    private String buName;

    @ApiModelProperty("交易日期")
    //@JsonFormat(pattern = "yyyy-MM-dd")
    private LocalDateTime ioDate;

    @ApiModelProperty("客户ID")
    private Long custId;
    @ApiModelProperty("客户编码")
    private String custCode;
    @ApiModelProperty("客户名称")
    private String custName;

    @ApiModelProperty("币种")
    private String currCode;
    @ApiModelProperty("币种名称")
    private String currCodeName;

    @ApiModelProperty("仓库id")
    private Long whId;

    @ApiModelProperty("功能区")
    private String deter2;

    @ApiModelProperty("来源单据类别 [UDC]COM:DOC_CLS")
    @SysCode(sys = "yst-supp",mod = "DOC_CLS")
    private String srcDocCls;

    @ApiModelProperty("来源单据类别名称")
    private String srcDocClsName;

    @ApiModelProperty("来源单据编号")
    private String srcDocNo;

    @ApiModelProperty("来源单据ID")
    private Long srcDocId;

    @ApiModelProperty("场景码")
    private String sceneCode;

    @ApiModelProperty("场景码名")
    private String sceneCodeName;

    @ApiModelProperty("创建人")
    private String creator;

    @ApiModelProperty("创建人ID")
    private Long createUserId;

    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty("来源单据明细ID")
    private Long srcDocDid;

    @ApiModelProperty("商品id")
    private Long itemId;

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("商品规格")
    private String spec;

    @ApiModelProperty("商品分类")
    private String itemCateCode;

    @ApiModelProperty("商品分类")
    private String itemCateName;

    @ApiModelProperty("税率 进项VAT")
    private BigDecimal taxRate;

    @ApiModelProperty("税率 进项VAT")
    private String taxRateNo;

    @ApiModelProperty("税率 销项VAT")
    private String taxRateNo2;

    @ApiModelProperty("税率 销项VAT")
    private BigDecimal taxRateOut;

    @ApiModelProperty("单位 [UDC]COM:UOM")
    private String uom;

    @ApiModelProperty("单位名称")
    private String uomName;

    @ApiModelProperty("交易数量")
    //@NumberFormat(value = "#,###.##")
    private BigDecimal qty;

    @ApiModelProperty("采购单价 内部结算")
    private BigDecimal purchsaPrice;

    @ApiModelProperty("销售单价 内部结算")
    private BigDecimal salePrice;

    @ApiModelProperty("供应商ID")
    private Long suppId;
    @ApiModelProperty("供应商编号")
    private String suppCode;
    @ApiModelProperty("供应商名称")
    private String suppName;

    @ApiModelProperty("业务类型【UDC】INV:BUSI_TYPE")
    private String ioCode;
    @ApiModelProperty("业务类型名称")
    private String ioCodeName;

    @ApiModelProperty("批次号")
    private String lotNo;

    @ApiModelProperty("记账日期")
    private LocalDateTime finDate;

    @ApiModelProperty("生成财务单据标识 0未生成公司间应收单/应付单，1已经生成，2生成失败")
    private Integer finInterFlag;

    @ApiModelProperty(value = "含税金额")
    private BigDecimal saleAmt;

    @ApiModelProperty("单位成本")
    private BigDecimal costPrice;

    @ApiModelProperty("成本金额")
    private BigDecimal costAmt;

   /* @ApiModelProperty(value = "客户/供应商的内外部)")
    private String inOutCust;

    @ApiModelProperty("关联公司编码")
    private String relevanceOuCode;

    @ApiModelProperty("应付暂估差异")
    private BigDecimal invoicePriceVariance;*/
}
