package com.elitesland.inv.dto.invstk;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * <p>
 * 库存对外公共参数
 * </p >
 *
 * @author jeesie.jiang
 * @date 2021/6/03
 */
@Data
public class InvStkRpcDtoParam implements Serializable{

    private static final long serialVersionUID = -6387906475365034965L;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("商品ID")
    @NotNull
    private Long itemId;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("异构ID")
    private Long variId;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("仓库ID")
    @NotNull
    private Long whId;

    @ApiModelProperty("功能库区[UDC]INV:FUNC_TYPE")
    @NotEmpty
    private String deter2;

    @ApiModelProperty("deter1")
    private String deter1;

    @ApiModelProperty("批次号")
    private String lotNo;

    @ApiModelProperty("序列号")
    private String snNo;

    @ApiModelProperty("limit1")
    private String limit1;

    @ApiModelProperty("limit2")
    private String limit2;

    @ApiModelProperty("limit3")
    private String limit3;

    @ApiModelProperty("合作伙伴编码")
    private String pCode;

    @ApiModelProperty("库存合作伙伴类型")
    private String pType;

    @ApiModelProperty("转换单位")
    @NotEmpty
    private String toUom;

    @ApiModelProperty("功能库区类型")
    private String deter2Type;









}
