package com.elitesland.inv.dto.invlot.param;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 批次主档(InvLot)实体类
 *
 * @author makejava
 * @since 2020-07-30 15:08:04
 */

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author makejava
 * @since 2020-07-30 15:08:04
 */
@Data
@ApiModel(value = "inv_lot", description = "批次主档")
public class InvLotSaveZyRpcParam implements Serializable {
    private static final long serialVersionUID = 796180452162749878L;

    /**
     * 批次号
     */
    @ApiModelProperty("批次号")
    private String lotNo;
    @ApiModelProperty("首次批次号")
    private Long firstBatchNo;
    @ApiModelProperty("上游批次号 可空")
    private Long  upstreamBatchNo;
    @ApiModelProperty("首次入库价格")
    private BigDecimal firstIdoPrice;
    @ApiModelProperty("批次价格")
    private BigDecimal lotPrice;
    @ApiModelProperty("追溯序号")
    private Long traceabilityNumber;
}
