package com.elitesland.inv.openapi.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author : chen.niu
 * @description : 出库单确认医药行业WMS回调
 * @date : 2025/10/28 13:51
 */
@Data
@ApiModel(value = " InvOdoConfirmParam", description = "采购入库WMS对象")
public class InvOdoConfirmParam {
    private static final long serialVersionUID = -956075481038757183L;

    @ApiModelProperty("出库单单号，即创建出库单时来源单号")
    @NotBlank(message = "出库单单号")
    private String docNo;

    @ApiModelProperty(value = "来源系统 SAP系统：SAP，SRM系统：SRM，华鼎：HuaWms，自建WMS：TllWms，报单平台：BDPT", required = true)
    @NotBlank(message = "来源系统不能为空")
    private String sourceSystem;

    @ApiModelProperty(value = "出库类型", required = true)
    @NotBlank(message = "出库单单号")
    private String odoType;

    @ApiModelProperty(value = "货主编码", required = true)
    @NotBlank(message = "货主编码")
    private String whcode;

    @ApiModelProperty(value = "客商编码", required = true)
    @NotBlank(message = "客商编码")
    private String suppCode;

    @ApiModelProperty(value = "外部仓库编码", required = true)
    @NotBlank(message = "外部仓库编码")
    private String outWhCode;

//    @ApiModelProperty(value = "wms入库单号", required = true)
//    @NotBlank(message = "wms入库单号")
//    private String outBizCode;

    @ApiModelProperty(value = "请求id，唯一标识", required = true)
    @NotBlank(message = "请求id不能为空")
    private String requestId;

    @ApiModelProperty(value = "请求时间，yyyy-MM-dd HH:mm:ss", required = true)
    @NotBlank(message = "请求时间不能为空")
    private String requestTime;

    @ApiModelProperty("出库日期")
    private String recvDate;

    @ApiModelProperty("出库明细")
    @NotEmpty(message = "出库明细")
    private List<InvOdoDOutResultVO> details;

    @Data
    public static class InvOdoDOutResultVO implements Serializable {
        @ApiModelProperty("出库单明细Id")
        @NotBlank(message = "出库单明细Id")
        private Long did;

        @ApiModelProperty("数量")
        @NotBlank(message = "数量不能为空")
        private BigDecimal qty;

        @ApiModelProperty("批次")
        private String lotNo;

        @ApiModelProperty("仓库编码")
        private String whCode;

        @ApiModelProperty("商品编码")
        private String itemCode;

        @ApiModelProperty("商品名称")
        private String itemName;

        @ApiModelProperty("库存状态")
        private String limit;

        @ApiModelProperty("入库日期")
        private String recvDate;
    }
}
