package com.elitesland.inv.dto.invAj;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitescloud.cloudt.sys.component.med.BaseModelMedOrderDVO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author jeesie
 * @description:
 * @datetime 2023年 09月 01日 11:03
 * @version: 1.0
 */
@Data
@ApiModel(value = "InvAjDSaveRpcDTO", description = "库存调整保存明细")
public class InvAjdSaveRpcDTO extends BaseModelMedOrderDVO implements Serializable {

    private static final long serialVersionUID = -2585004144033119183L;

    @ApiModelProperty("调整数量")
    @NotNull(message = "调整数量不能为空")
    private BigDecimal qty;

    @ApiModelProperty("调整数量2")
    private BigDecimal qty2;

    @ApiModelProperty("单位")
    @NotBlank(message = "单位不能为空")
    private String uom;

    @ApiModelProperty("批次号,启用商品属性批次必须传")
    private String lotNo;

    @ApiModelProperty("生产日期")
    private LocalDateTime manuDate;

    @ApiModelProperty("商品编码")
    @NotBlank(message = "商品编码不能为空")
    private String itemCode;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("商品类型")
    private String itemype2;

    @ApiModelProperty("异构ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long variId;

    @ApiModelProperty("库区")
    private String deter2;

    @ApiModelProperty("库存状态")
    private String limit1;

    @ApiModelProperty("限定2")
    private String limit2;

    @ApiModelProperty("限定3")
    private String limit3;

    @ApiModelProperty("来源订单明细行号")
    private Double sourceLineNo;

    @ApiModelProperty("来源订单明细ID")
    private Long sourceDocDid;

    //医药字段
    @ApiModelProperty(value = "产品批号")
    private String productNo;
    @ApiModelProperty("通用名称")
    private String generalName;
    @ApiModelProperty("商品名")
    private String productName;
    @ApiModelProperty("英文名称")
    private String englishName;
    @ApiModelProperty("浓度规格")
    private String concSpec;
    @ApiModelProperty("批准文号")
    private String approvalNumber;
    @ApiModelProperty("产地")
    private String origin;
    @ApiModelProperty("剂型, [UDC]yst-supp:DOSAGE_FORM")
    private String dosageForm;
    @ApiModelProperty("剂型名称")
    private String dosageFormName;
    @ApiModelProperty("库存调整类型")
    String docType2;
}
