package com.elitesland.inv.dto.odo;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;


/**
 * @author jeesie
 */
@Data
@ApiModel(value = "InvOdoCancelParamRpcDTO", description = "出库单取消")
public class InvOdoCancelParamRpcDTO implements Serializable {
    private static final long serialVersionUID = -1288939798948998849L;

    @ApiModelProperty("关联单据类别")
    @NotBlank(message = "来源单据类别 不能为空")
    private String relateDocCls;

    @ApiModelProperty("来源单据ID")
    @NotNull(message = "来源单据ID 不能为空")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateDocId;

    @ApiModelProperty("是否走接口")
    private Boolean initFlag;

    public Boolean getInitFlag() {
        if(this.initFlag == null){
            return Boolean.FALSE;
        }
        return this.initFlag;
    }
}
