package com.elitesland.inv.dto.invIo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

@Data
@ApiModel("流水计算参数")
public class InvIoCalcParamRpcDTO implements Serializable {

    private static final long serialVersionUID = 4915904878540056350L;

    @ApiModelProperty("唯一ID")
    private Long id;

    @ApiModelProperty("公司id")
    private Long ouId;

    @ApiModelProperty("仓库id")
    private Long whId;

    @ApiModelProperty("商品id")
    private Long itemId;

    @ApiModelProperty("日期从")
    private LocalDateTime dateFrom;

    @ApiModelProperty("日期至")
    private LocalDateTime dateTo;

    @ApiModelProperty("库存场景")
    private List<String> sceneCodes;
}
