package com.elitesland.inv.provider;


import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.inv.Application;
import com.elitesland.inv.dto.invAj.InvAjRpcDTO;
import com.elitesland.inv.dto.invAj.InvAjSaveRpcDTO;
import org.apache.kafka.clients.admin.internals.AdminApiHandler;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * @author jeesie
 */
@Validated
@FeignClient(name = Application.NAME,path = Application.PATH + InvAjProvider.PATH)
public interface InvAjProvider {

    String PATH = "/invAj";

    /**
     * 返回单据号
     */
    @PostMapping("/saveConfirmAj")
    ApiResult<Long> saveAndConfirmAj(@RequestBody InvAjSaveRpcDTO saveRpcDTO);

    @GetMapping("/getById")
    ApiResult<InvAjRpcDTO> getById(@RequestParam("id") Long id);

    /**
     * 新增+审批通过
     */
    @PostMapping("/saveAndApproveAj")
    ApiResult<Long> saveAndApproveAj(@RequestBody InvAjSaveRpcDTO saveRpcDTO);

    /**
     * 新增
     */
    @PostMapping("/saveAj")
    ApiResult<Long> saveAj(@RequestBody InvAjSaveRpcDTO saveRpcDTO);

    /**
     * 审批通过
     */
    @PostMapping("/approveAj/{id}")
    ApiResult<Long> approveAj(@PathVariable("id") Long id);

}
