package com.elitesland.inv.provider;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.inv.Application;
import com.elitesland.inv.dto.cost.InvCostDetailRpcDTO;
import com.elitesland.inv.dto.cost.InvCostDetailRpcDtoParam;
import com.elitesland.inv.dto.freeze.InvFreezeApplySaveRpcDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @author brayson
 * @date 2025/12/3
 * @description
 */
@Validated
@FeignClient(name = Application.NAME,path = Application.PATH + InvFreezeApplyProvider.PATH)
public interface InvFreezeApplyProvider {

    String PATH = "/inv/freezeApply";

    /**
     * 保存 库存冻结申请单
     * @param param 查询条件
     * @return 结果
     */
    @PostMapping("/save")
    ApiResult<Long> save(@RequestBody InvFreezeApplySaveRpcDTO param);

    /**
     * 保存并审批通过 库存冻结申请单
     * @param param 查询条件
     * @return 结果
     */
    @PostMapping("/saveAndApprove")
    ApiResult<Long> saveAndApprove(@RequestBody InvFreezeApplySaveRpcDTO param);

    /**
     * 批量保存 库存冻结申请单
     * @param params 查询条件
     * @return 结果
     */
    @PostMapping("/batchSave")
    ApiResult<List<Long>> batchSave(@RequestBody List<InvFreezeApplySaveRpcDTO> params);

    /**
     * 批量保存并审批通过 库存冻结申请单
     * @param params 查询条件
     * @return 结果
     */
    @PostMapping("/batchSaveAndApprove")
    ApiResult<List<Long>> batchSaveAndApprove(@RequestBody List<InvFreezeApplySaveRpcDTO> params);

}
