package com.elitesland.inv.dto.odo;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author jeesie
 * @description:
 * @datetime 2023年 08月 24日 21:55
 * @version: 1.0
 */
@Data
@ApiModel(value = "invSignInvOdoRpcDTOParam", description = "签收库存出库单入参")
public class InvSignOdoRpcDtoParam implements Serializable {
    private static final long serialVersionUID = 9017176312526212822L;

    @ApiModelProperty("来源单据类别")
    private String relateDocCls;

    @ApiModelProperty("来源单据ID")
    @JsonSerialize(using = ToStringSerializer.class)
    @NotNull(message = "来源单据ID不能为空")
    private Long relateDocId;

    @ApiModelProperty("来源单据编号")
    @NotEmpty(message = "来源单据号不能为空")
    private String relateDocNo;

    @ApiModelProperty("出库单ID")
    @JsonSerialize(using = ToStringSerializer.class)
    @NotNull(message = "出库单不能为空")
    private Long odoId;

    @ApiModelProperty("签收明细")
    private List<InvSignOdoDtlParam> details;

    @Data
    public static class InvSignOdoDtlParam implements Serializable {

        private static final long serialVersionUID = -3161063436600542040L;

        @ApiModelProperty("出库单明细ID")
        @JsonSerialize(using = ToStringSerializer.class)
        @NotNull(message = "出库单明细ID不能为空")
        private Long odoDid;

        @ApiModelProperty("出库单单据明细行号")
        private BigDecimal ododLineno;

        @ApiModelProperty("来源单据明细ID")
        @JsonSerialize(using = ToStringSerializer.class)
        @NotNull(message = "来源单据明细ID不能为空")
        private Long relateDocDid;

        @ApiModelProperty("来源单据行号")
        @NotNull(message = "来源单据明细行号不能为空")
        private BigDecimal relateDocLineno;

        @ApiModelProperty("签收数量")
        @NotNull(message = "签收数量不能为空")
        private BigDecimal signQty;

    }
}
