package com.elitesland.inv.dto.invlot.param;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 批次主档(InvLot)实体类
 *
 * @author makejava
 * @since 2020-07-30 15:08:04
 */

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author makejava
 * @since 2020-07-30 15:08:04
 */
@Data
@ApiModel(value = "inv_lot", description = "批次主档")
public class InvLotSaveRpcParam implements Serializable {
    private static final long serialVersionUID = 796180452162749878L;

    /**
     * 公司ID
     */
    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;
    private String ouCode;
    private String ouName;
    /**
     * BUIDexpireDay
     */
    @ApiModelProperty("BUID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;
    /**
     * 品项ID
     */
    @ApiModelProperty("品项ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;
    /**
     * 异构ID
     */
    @ApiModelProperty("异构ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long variId;
    /**
     * 品项编号
     */
    @ApiModelProperty("品项编号")
    private String itemCode;
    /**
     * 批次号
     */
    @ApiModelProperty("批次号")
    private String lotNo;
    /**
     * 批次说明
     */
    @ApiModelProperty("批次说明")
    private String lotDesc;
    /**
     * 质量状态
     */
    @ApiModelProperty("质量状态")
    private String qcStatus;

    /**
     * 保质期天数
     */
    @ApiModelProperty("保质期天数")
    private Integer expireDays;
    /**
     * 生产日期
     */
    @ApiModelProperty("生产日期")
    private LocalDateTime manuDate;
    /**
     * 生产批次
     */
    @ApiModelProperty("生产批次")
    private String menuLotNo;
    /**
     * 整批号
     */
    @ApiModelProperty("整批号")
    private String batchNo;
    /**
     * 失效日期
     */
    @ApiModelProperty("失效日期")
    private LocalDateTime expireDate;
    /**
     * 剩余效期天数 每天自动计算
     */
    @ApiModelProperty("剩余效期天数 每天自动计算")
    private Integer untilExpireDays;
    /**
     * 新鲜度 每天自动计算。[UDC]COM:FRESS_TYPE
     */
    @ApiModelProperty("新鲜度 每天自动计算。[UDC]COM:FRESS_TYPE")
    private String fressType;
    /**
     * 首次入库日期
     */
    @ApiModelProperty("首次入库日期")
    private LocalDateTime firstInDate;
    /**
     * 最后出库日期
     */
    @ApiModelProperty("最后出库日期")
    private LocalDateTime lastOutDate;
    /**
     * 销售截止日期
     */
    @ApiModelProperty("销售截止日期")
    private LocalDateTime maxSaleDate;
    /**
     * 原产国
     */
    @ApiModelProperty("原产国")
    private String menuCountry;
    /**
     * 产地描述
     */
    @ApiModelProperty("产地描述")
    private String menuDesc;
    /**
     * 产地证明编号
     */
    @ApiModelProperty("产地证明编号")
    private String menuDocNo;
    /**
     * 制造商ID
     */
    @ApiModelProperty("制造商ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long manuerId;
    /**
     * 制造商编号
     */
    @ApiModelProperty("制造商编号")
    private String manuerCode;
    /**
     * 制造商名称
     */
    @ApiModelProperty("制造商名称")
    private String manuerName;
    /**
     * 供应商ID
     */
    @ApiModelProperty("供应商ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long suppId;


    /**
     * 货主类型 供应商/客户，DCH不用
     */
    @ApiModelProperty("货主类型 供应商/客户，DCH不用")
    private String ownerType;
    /**
     * 货主ID DCH不用
     */
    @ApiModelProperty("货主ID DCH不用")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ownerId;
    /**
     * 货主编码 DCH不用
     */
    @ApiModelProperty("货主编码 DCH不用")
    private String ownerCode;
    /**
     * 来源单据类别
     */
    @ApiModelProperty("来源单据类别")
    private String srcDocCls;
    /**
     * 来源单据ID
     */
    @ApiModelProperty("来源单据ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long srcDocId;
    /**
     * 来源单据编号
     */
    @ApiModelProperty("来源单据编号")
    private String srcDocNo;
    /**
     * 来源单据明细ID
     */
    @ApiModelProperty("来源单据明细ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long srcDocDid;

    @ApiModelProperty("来源单据明细行号 ")
    private Integer srcDoclineno;


    @ApiModelProperty("ES1")
    private String es1;

    @ApiModelProperty("ES2")
    private String es2;

    @ApiModelProperty("ES3")
    private String es3;

    @ApiModelProperty("ES4")
    private String es4;

    @ApiModelProperty("ES5")
    private String es5;

    @ApiModelProperty("ES6")
    private String es6;

    @ApiModelProperty("DATE1")
    private LocalDateTime date1;

    @ApiModelProperty("DATE2")
    private LocalDateTime date2;

    @ApiModelProperty("DATE3")
    private LocalDateTime date3;

    @ApiModelProperty("DATE4")
    private LocalDateTime date4;

    @ApiModelProperty("DATE5")
    private LocalDateTime date5;

    @ApiModelProperty("备注")
    private String remark;



}
