package com.elitesland.inv.dto.invwh;

import com.elitesland.inv.util.BaseModelDTO;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.List;

/**
 * <p>
 * 功能说明 仓库
 * </p>
 *
 * @author jeesie.jiang
 * @since 2021-06-1 14:00:47
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel( description = "仓库")
public class InvWhPartRpcDTO extends BaseModelDTO implements Serializable {
    private static final long serialVersionUID = -84413014701696628L;

    /**
     * 仓库id
     */
    @ApiModelProperty("仓库id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("权限id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long secBuId;

    /**
     * 仓库编号
     */
    @ApiModelProperty("仓库编号")
    private String whCode;

    /**
     * 仓库名称
     */
    @ApiModelProperty("仓库名称")
    private String whName;
    /**
     * 个人仓雇员外部编号
     */
    @ApiModelProperty("个人仓雇员外部编号")
    private List<String> empeSimNoList;

    /**
     * 仓库类型 [UDC]INV:WH_TYPE
     */
    @ApiModelProperty("仓库类型 [UDC]INV:WH_TYPE")
    @SysCode(sys = "yst-inv", mod = "WH_TYPE")
    private String whType;
    private String whTypeName;

    /**
     * 公司ID
     */
    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;
    @ApiModelProperty("公司名称")
    private String ouName;
    @ApiModelProperty("公司编码")
    private String ouCode;
    @ApiModelProperty("公司币种")
    private String ouCurr;


    @ApiModelProperty("供应商合作公司")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateOuId;

    @ApiModelProperty("供应商合作公司编码")
    private String relateOuCode;

    /**
     * 地址号 仓库本身的地址号
     */
    @ApiModelProperty("地址号 仓库本身的地址号")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long addrNo;

    @ApiModelProperty("是否3PL仓库-京云仓标志")
    private Integer thirdplFlag;

    @ApiModelProperty("erp仓库编码")
    private String erpCode;

    @ApiModelProperty("仓库属性-售后仓")
    private String es1;
    private String es1Name;

    /**
     * 营业厅编码
     */
    @ApiModelProperty("营业厅编码")
    private String businessCode;
    /**
     * 仓库状态
     */
    @ApiModelProperty("仓库状态")
    private String whStatus;

    @ApiModelProperty("库区")
    private List<InvWhAreaRpcDTO> invWhAreaList;

    @ApiModelProperty("京东仓库关联码")
    private String jdrelateCode;

    @ApiModelProperty("京东事业部编码")
    private String jdsybCode;

    @ApiModelProperty("京云仓编码")
    private String jdwhCode;

    @ApiModelProperty("不良京云仓")
    private Integer jdbadFlag;


}
