package com.elitesland.inv.provider;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.inv.Application;
import com.elitesland.inv.dto.invstk.InvStkCommonResultRpcDto;
import com.elitesland.inv.dto.invstk.param.InvTradeStkOperateRpcParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @author jeesie
 * 关联交易逆向&&补单流水库存处理
 */
@Validated
@FeignClient(name = Application.NAME,path = Application.PATH + InvTradeStkOperateProveider.PATH)
public interface InvTradeStkOperateProveider {

    String PATH = "/invStk";

    /**
     * 结算路径逆向退货库存操作
     * @param tradeStkOperateRpcParam
     * @return
     */
    @PostMapping("/relateTradeStkOpt")
    ApiResult<InvStkCommonResultRpcDto> relateTradeStkOperate(@RequestBody InvTradeStkOperateRpcParam tradeStkOperateRpcParam);

    /**
     * 结算路径正向调拨发货库存操作
     * @param tradeStkOperateRpcParam
     * @return
     */
    @PostMapping("/relateTradeTranStkOperate")
    ApiResult<InvStkCommonResultRpcDto> relateShipTranStkOperate(@RequestBody InvTradeStkOperateRpcParam tradeStkOperateRpcParam);

    /**
     * 结算路径正向调拨签收
     * @param tradeStkOperateRpcParam
     * @return
     */
    @PostMapping("/relateSignTranStkOperate")
    ApiResult<InvStkCommonResultRpcDto> relateSignTranStkOperate(@RequestBody InvTradeStkOperateRpcParam tradeStkOperateRpcParam);
}
