package com.elitesland.inv.dto.invAsm;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
@ApiModel(value = "InvAsmDSaveRpcDTO", description = "库内组装明细")
public class InvAsmDSaveRpcDTO implements Serializable {

    private static final long serialVersionUID = 5804989339298662169L;

    @ApiModelProperty("单据号")
    private String docNo;

    @ApiModelProperty("仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;

    @ApiModelProperty("仓库名称")
    private String whName;

    @ApiModelProperty("仓库编码")
    private String whCode;

    @ApiModelProperty("功能区")
    private String deter2;

    @ApiModelProperty("功能区名")
    private String deter2Name;

    @ApiModelProperty("行号")
    private Double lineNo;

    @ApiModelProperty("行状态")
    private String lineStatus;

    @ApiModelProperty("行类型 [UDC]COM:IO")
    @SysCode(sys = "yst-supp", mod = "IO")
    private String lineType;
    private String lineTypeName;

    @ApiModelProperty("品项ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    @ApiModelProperty("品项编码")
    private String itemCode;

    @ApiModelProperty("品项名称")
    private String itemName;

    @ApiModelProperty("是否启用批次")
    private Boolean lotFlag;

    @ApiModelProperty("异构ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long variId;

    @ApiModelProperty("序列号")
    private String snNo;

    @ApiModelProperty("数量")
    private BigDecimal qty;

    @ApiModelProperty("实际出入数量")
    private BigDecimal acQty;

    @ApiModelProperty("实际出入库批次")
    private String acLotNo;

    @ApiModelProperty("单位")
    @SysCode(sys = "yst-supp",mod = "UOM")
    private String uom;
    private String uomName;

    @ApiModelProperty("数量2")
    private BigDecimal qty2;

    @ApiModelProperty("可供量")
    private BigDecimal avalQty;

    @ApiModelProperty("单位2")
    private String uom2;

    @ApiModelProperty("单位转换率")
    private Float uomRatio;

    @ApiModelProperty("单位转换率2")
    private Float uomRatio2;

    @ApiModelProperty("生产批号")
    private String manuLotNo;

    @ApiModelProperty("税额")
    private BigDecimal taxAmt;

    @ApiModelProperty("含税金额")
    private BigDecimal amt;

    @ApiModelProperty("不含税金额")
    private BigDecimal netAmt;

    @ApiModelProperty("记账币种")
    private String homeCurr;

    @ApiModelProperty("交易币种")
    private String currCode;

    @ApiModelProperty("交易币种名")
    private String currCodeName;

    @ApiModelProperty("汇率")
    private Float currRate;

    @ApiModelProperty("外币不含税金额")
    private BigDecimal currNetAmt;

    @ApiModelProperty("外币含税金额")
    private BigDecimal currAmt;

    @ApiModelProperty("单位成本")
    private BigDecimal costPrice;

    @ApiModelProperty("成本金额")
    private BigDecimal costAmt;

    @ApiModelProperty("外部单据号")
    private String outerNo;

    @ApiModelProperty("外部单据行号")
    private String outerLineno;

    @ApiModelProperty("ES1")
    private String es1;

    @ApiModelProperty("ES2")
    private String es2;

    @ApiModelProperty("ES3")
    private String es3;

    @ApiModelProperty("ES4")
    private String es4;

    @ApiModelProperty("ES5")
    private String es5;

    @ApiModelProperty("ES6")
    private String es6;

    @ApiModelProperty("保质期天数")
    private Integer expireDays;

    @ApiModelProperty("生产日期")
    private LocalDateTime manuDate;

    @ApiModelProperty("失效日期")
    private LocalDateTime expireDate;

    @ApiModelProperty("入库日期")
    private LocalDateTime stkInDate;

    @ApiModelProperty("项目编号")
    private String projectCode;

    @ApiModelProperty("项目名称")
    private String projectName;

    @ApiModelProperty("新鲜度 每天自动计算。[UDC]COM:FRESS_TYPE")
    @SysCode(sys = "yst-supp",mod = "FRESS_TYPE")
    private String fressType;
    private String fressTypeName;

    @ApiModelProperty("批次")
    private String lotNo;

    @ApiModelProperty("批次ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long lotId;

    @ApiModelProperty("关联单据明细ID")
    private Long relateDocDid;

    @ApiModelProperty("关联单据明细行号")
    private Integer relateDocLineno;

    @ApiModelProperty("关联单据类别 [UDC]COM:DOC_CLS")
    private String relateDocCls;

    @ApiModelProperty("关联单据ID")
    private Long relateDocId;

    @ApiModelProperty("关联单据编号")
    private String relateDocNo;

    @ApiModelProperty("关联单据2明细ID")
    private Long relateDoc2Did;

    @ApiModelProperty("关联单据2明细行号")
    private Integer relateDoc2Lineno;

    @ApiModelProperty("关联单据类别 [UDC]COM:DOC_CLS")
    private String relateDoc2Cls;

    @ApiModelProperty("关联单据ID")
    private Long relateDoc2Id;

    @ApiModelProperty("关联单据编号")
    private String relateDoc2No;

    @ApiModelProperty("品牌")
    private String brand;

    @ApiModelProperty("品牌名称（暂时使用）")
    private String brandName;

    @ApiModelProperty("商品规格")
    private String itemSpec;

    @ApiModelProperty("发起人")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long applyEmpId;

    @ApiModelProperty("发起人")
    private String applyEmpIdName;

    @ApiModelProperty("保质期天数")
    private Integer storeExpireDays;

    @ApiModelProperty("组套标识")
    private Boolean isBom;

    @ApiModelProperty("组套主件ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long bomPid;

    @ApiModelProperty("组套子件ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long bomCid;

    @ApiModelProperty("组套比例")
    private BigDecimal preQty;


}
