package com.elitesland.inv.dto.invlot.param;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * <p>
 * 批次主信息（公共方法21入参）
 * </p>
 *
 * @author ssy
 * @since 2020-07-30 09:39:25
 */
@Data
@ApiModel(value = "批次主信息（公共方法21入参）", description = "批次主信息（公共方法21入参）")
public class InvLotCommon21RpcParam implements Serializable {

    private static final long serialVersionUID = 4656228026850735086L;

    @ApiModelProperty("商品ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    @ApiModelProperty("商品编号")
    private String itemCode;

    @ApiModelProperty("异构ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long variId;

    @ApiModelProperty("批次号")
    private String lotNo;

    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

}
