package com.elitesland.inv.provider;


import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.inv.Application;
import com.elitesland.inv.dto.odo.*;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;


/**
 * @author jeesie
 */
@Validated
@FeignClient(name = Application.NAME,path = Application.PATH + InvOdoProvider.PATH)
public interface InvOdoProvider {
    String PATH = "/invOdoProvider";

    /**
     * 创建出库单
     * 单据状态为草稿
     * @param invOdoSaveRpcDTO
     * @return 返回出库单ID
     */
    @PostMapping("/saveInvOdo")
    ApiResult<String> saveInvOdo(@RequestBody InvOdoSaveRpcDTO invOdoSaveRpcDTO);

    /**
     * 签收出库单
     * @param signOdoRpcDtoParam
     * @return
     */
    @PostMapping("/signInvOdo")
    ApiResult<Boolean> signInvOdo(@RequestBody InvSignOdoRpcDtoParam signOdoRpcDtoParam);


    /**
     * 根据来源单号查询是否存在相关生效的出库单；
     * @param checkParamRpcDTO 来源单据信息
     * @return true:存在；false:不存在
     */
    @PostMapping("/checkInvOdoByParam")
    Boolean checkInvOdoByParam(@RequestBody InvOdoCheckParamRpcDTO checkParamRpcDTO);


    /**
     * 出库单确认出库
     * @param confirmParamRpcDTO
     * @return true 成功 false 失败
     */
    @PostMapping("/confirmInvOdo")
    ApiResult<Boolean> confirmInvOdo(@RequestBody InvOdoConfirmParamRpcDTO confirmParamRpcDTO);


    /**
     * 创建且确认出库
     * @param invOdoSaveRpcDTO
     * @return 返回出库单ID
     */
    @PostMapping("/saveAndConfirmInvOdo")
    ApiResult<String> saveAndConfirmInvOdo(@RequestBody InvOdoSaveRpcDTO invOdoSaveRpcDTO);

    /**
     * 取消出库单
     * @param param
     * @return 返回出库单ID
     */
    @PostMapping("/cancelInvOdo")
    ApiResult<Long> cancelInvOdo(@RequestBody InvOdoCancelParamRpcDTO param);













}
