package com.elitesland.inv.dto.invstk.param;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author Tom.su
 * @program yst-inv
 * @description
 * @date 2022/04/24 10:46
 */
@Data
@ApiModel(value = "库存操作公共Dubbo接口入参", description = "库存操作公共Dubbo接口入参")
@Valid
public class InvStkCommonOperateRpcParam implements Serializable {

    private static final long serialVersionUID = -8648391985956127665L;

    @ApiModelProperty("唯一请求ID")
    @NotBlank(message = "唯一请求ID不能为空")
    private String requestId;

    @ApiModelProperty("来源系统")
    @NotBlank(message = "来源系统不能为空")
    private String source;

    @ApiModelProperty("库存场景码")
    @NotBlank(message = "库存场景码不能为空")
    private String sceneCode;

    @ApiModelProperty("原库存库存操作明细体")
    private List<Body> sourceBodyList;

    @ApiModelProperty("目的库存库存操作明细体")
    private List<Body> targetBodyList;


    @Data
    public static class Body implements Serializable {

        private static final long serialVersionUID = -5549577961708376277L;

        @ApiModelProperty("操作数量")
        private BigDecimal qty;

        @ApiModelProperty("单据号")
        @NotBlank(message = "单据号不能为空")
        private String docNo;

        @ApiModelProperty("行号")
        private Double lineNo;

        @ApiModelProperty("日期")
        private LocalDateTime opDate;

        @ApiModelProperty("操作人")
        @JsonSerialize(using = ToStringSerializer.class)
        private Long createUserId;

        @ApiModelProperty("来源单据类别")
        private String srcDocCls;

        @ApiModelProperty("来源单据ID")
        @JsonSerialize(using = ToStringSerializer.class)
        private Long srcDocId;

        @ApiModelProperty("来源单据明细ID")
        @JsonSerialize(using = ToStringSerializer.class)
        private Long srcDocDid;

        @ApiModelProperty("来源单据关联的订单类别")
        private String srcDocCls2;

        @ApiModelProperty("来源单据ID2")
        @JsonSerialize(using = ToStringSerializer.class)
        private Long srcDocId2;

        @ApiModelProperty("来源单据编号2")
        private String srcDocNo2;

        @ApiModelProperty("来源订单明细ID2")
        @JsonSerialize(using = ToStringSerializer.class)
        private Long srcDocDid2;

        @JsonSerialize(using = ToStringSerializer.class)
        @ApiModelProperty("商品ID")
        @NotNull
        private Long itemId;

        @JsonSerialize(using = ToStringSerializer.class)
        @ApiModelProperty("异构ID")
        private Long variId;

        @JsonSerialize(using = ToStringSerializer.class)
        @ApiModelProperty("仓库ID")
        private Long whId;

        @ApiModelProperty("温层[UDC]INV:TEMP_TYPE")
        private String deter1;

        @ApiModelProperty("功能库区[UDC]INV:FUNC_TYPE")
        @NotEmpty
        private String deter2;

        @ApiModelProperty("客户号")
        private String deter3;

        @ApiModelProperty("库存合作伙伴类型")
        private String pType;

        @ApiModelProperty("库存合作伙伴编码")
        private String pCode;

        @ApiModelProperty("批次号")
        private String lotNo;

        @ApiModelProperty("单位")
        @NotBlank(message = "商品单位不能为空")
        private String uom;

        @ApiModelProperty("limit1")
        private String limit1;

        @ApiModelProperty("limit2")
        private String limit2;

        @ApiModelProperty("limit3")
        private String limit3;

        @ApiModelProperty("序列号")
        private String snNo;

        @ApiModelProperty("销售配货单据明细ID")
        @JsonSerialize(using = ToStringSerializer.class)
        private Long srcDocDDid;
        @ApiModelProperty("公司ID")
        @JsonSerialize(using = ToStringSerializer.class)
        private Long ouId;

        @ApiModelProperty("记账日期")
        private LocalDateTime finDate;

        /***  卡券相关参数   **/

        /*** 制卡单入库时传入 ***/
        @ApiModelProperty("卡号范围 最小卡号，仅制卡单入库时需要传")
        private String startCardNo;

        @ApiModelProperty("卡号范围 最大卡号，仅制卡单入库时需要传")
        private String endCardNo;

        @ApiModelProperty("卡券批次，仅制卡单入库时需要传")
        private String cardLotNo;

        @ApiModelProperty("卡券类型，仅制卡单入库时需要传")
        private String cardType;

        @ApiModelProperty("卡券同步时间，仅制卡单入库时需要传")
        private LocalDateTime syncTime;
    }
}
