package com.elitesland.inv.provider;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.inv.Application;
import com.elitesland.inv.dto.card.*;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.math.BigDecimal;
import java.util.List;

@Validated
@FeignClient(name = Application.NAME,path = Application.PATH + InvStkCardApiProvider.PATH)
public interface InvStkCardApiProvider {

    String PATH = "/invCard/api";

    /**
     * 查询卡号
     * @param cardQueryRpcDTO
     * @return
     */
    @PostMapping("/queryCardNo")
    ApiResult<List<String>> queryCardNo(@RequestBody CardQueryRpcDTO cardQueryRpcDTO);

    /**
     * 查询
     * @param cardQueryRpcDTO
     * @return
     */
    @PostMapping("/query")
    ApiResult<List<InvStkCardRpcDTO>> query(@RequestBody CardQueryRpcDTO cardQueryRpcDTO);

    /**
     * 领用
     * @param cardUseRpcDTO
     */
    @PostMapping("/use")
    ApiResult use(@RequestBody CardUseRpcDTO cardUseRpcDTO);

    /**
     * 归还
     * @param cardUseRpcDTO
     */
    @PostMapping("/rtn")
    ApiResult rtn(@RequestBody CardUseRpcDTO cardUseRpcDTO);

    /**
     * 卡券占用。卡券领用单、归还单，草稿状态传入卡号占用
     *
     * @param cardLockRpcDTO
     */
    @PostMapping("/lock")
    ApiResult lock(@RequestBody CardLockRpcDTO cardLockRpcDTO);

    /**
     * 卡券释放占用。卡券领用单、归还单
     * @param cardLockRpcDTO
     */
    @PostMapping("/unlock")
    ApiResult unlock(@RequestBody CardLockRpcDTO cardLockRpcDTO);

    /**
     * 卡券释放占用。卡券领用单、归还单、卡券发货单、卡券退货入库单，整单释放，不指定具体卡号，释放单据占用的所有卡券
     * @param lockDocNo
     */
    @PostMapping("/unlock/all")
    ApiResult unlock(@RequestParam("lockDocNo") String lockDocNo, @RequestParam("lockDocCls") String lockDocCls);

    /**
     * 销售出库
     * @param lockDocNo 锁定卡券的单号，卡券销售订单单号
     * @param outDocNo 卡券发货单单号
     */
    @PostMapping("/saleOut")
    ApiResult saleOut(@RequestParam("lockDocNo") String lockDocNo, @RequestParam("outDocNo") String outDocNo);

    /**
     * 退货入库
     * @param lockDocNo 锁定卡券的退货入库订单单号
     * @param rtnInDocNo 卡券退货入库单单号
     */
    @PostMapping("/rtnIn")
    ApiResult rtnIn(@RequestParam("lockDocNo") String lockDocNo, @RequestParam("rtnInDocNo") String rtnInDocNo);

    /**
     * 核销
     * @param docNo 兑换单号
     * @param cardNo 核销的卡号
     */
    @PostMapping("/writeoff")
    ApiResult writeOff(@RequestParam("docNo") String docNo, @RequestParam("cardNo") String cardNo, @RequestParam("price") BigDecimal price);

    /**
     * 取消核销
     * @param docNo 兑换单号
     * @param cardNo 取消核销的卡号
     */
    @PostMapping("/cancelwriteoff")
    ApiResult cancelWriteOff(@RequestParam("docNo") String docNo, @RequestParam("cardNo") String cardNo);

    /**
     * 查询卡券指定状态数量
     * @param stkQueryDTO
     * @return
     */
    @PostMapping("/fetchCount")
    ApiResult<List<CardCountRpcDTO>> fetchCount(@RequestBody CardStkQueryDTO stkQueryDTO);
}
