package com.elitesland.inv.provider;

import com.elitesland.inv.Application;
import com.elitesland.inv.dto.card.CardLockRpcDTO;
import com.elitesland.inv.dto.card.CardQueryRpcDTO;
import com.elitesland.inv.dto.card.CardUseRpcDTO;
import com.elitesland.inv.dto.card.InvStkCardRpcDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.math.BigDecimal;
import java.util.List;

@Validated
@FeignClient(name = Application.NAME,path = Application.PATH + InvStkCardProvider.PATH)
@Deprecated(since = "改用 InvStkCardApiProvider，返回统一的ApiResult")
public interface InvStkCardProvider {

    String PATH = "/invCard";

    /**
     * 查询卡号
     * @param cardQueryRpcDTO
     * @return
     */
    @PostMapping("/queryCardNo")
    List<String> queryCardNo(@RequestBody CardQueryRpcDTO cardQueryRpcDTO);

    /**
     * 查询
     * @param cardQueryRpcDTO
     * @return
     */
    @PostMapping("/query")
    List<InvStkCardRpcDTO> query(@RequestBody CardQueryRpcDTO cardQueryRpcDTO);

    /**
     * 领用
     * @param cardUseRpcDTO
     */
    @PostMapping("/use")
    void use(@RequestBody CardUseRpcDTO cardUseRpcDTO);

    /**
     * 归还
     * @param cardUseRpcDTO
     */
    @PostMapping("/rtn")
    void rtn(@RequestBody CardUseRpcDTO cardUseRpcDTO);

    /**
     * 卡券占用。卡券领用单、归还单，草稿状态传入卡号占用
     *
     * @param cardLockRpcDTO
     */
    @PostMapping("/lock")
    void lock(@RequestBody CardLockRpcDTO cardLockRpcDTO);

    /**
     * 卡券释放占用。卡券领用单、归还单
     * @param cardLockRpcDTO
     */
    @PostMapping("/unlock")
    void unlock(@RequestBody CardLockRpcDTO cardLockRpcDTO);

    /**
     * 卡券释放占用。卡券领用单、归还单、卡券发货单、卡券退货入库单，整单释放，不指定具体卡号，释放单据占用的所有卡券
     * @param lockDocNo
     */
    @PostMapping("/unlock/all")
    void unlock(@RequestParam("lockDocNo") String lockDocNo, @RequestParam("lockDocCls") String lockDocCls);

    /**
     * 销售出库
     * @param lockDocNo 锁定卡券的单号，卡券销售订单单号
     * @param outDocNo 卡券发货单单号
     */
    @PostMapping("/saleOut")
    void saleOut(@RequestParam("lockDocNo") String lockDocNo, @RequestParam("outDocNo") String outDocNo);

    /**
     * 退货入库
     * @param lockDocNo 锁定卡券的退货入库订单单号
     * @param rtnInDocNo 卡券退货入库单单号
     */
    @PostMapping("/rtnIn")
    void rtnIn(@RequestParam("lockDocNo") String lockDocNo, @RequestParam("rtnInDocNo") String rtnInDocNo);

    /**
     * 核销
     * @param docNo 兑换单号
     * @param cardNo 核销的卡号
     */
    @PostMapping("/writeoff")
    void writeOff(@RequestParam("docNo") String docNo, @RequestParam("cardNo") String cardNo, @RequestParam("price") BigDecimal price);

    /**
     * 取消核销
     * @param docNo 兑换单号
     * @param cardNo 取消核销的卡号
     */
    @PostMapping("/cancelwriteoff")
    void cancelWriteOff(@RequestParam("docNo") String docNo, @RequestParam("cardNo") String cardNo);
}
