package com.elitesland.inv.dto.invTrn;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author jeesie.jiang
 * @date 2022-05-18 09:45
 * Desc: 库存转移保存实体
 */
@Data
@ApiModel(value = "invTrnSaveRpcDTO", description = "库存转移保存")
public class InvTrnSaveRpcDTO implements Serializable {

    private static final long serialVersionUID = -3542365886389320346L;

    @ApiModelProperty("转移类型 [UDC]INV:TRN_TYPE")
    @SysCode(sys = "yst-inv", mod = "TRN_TYPE")
    String docType;

    String docTypeName;

    @ApiModelProperty("申请人员工ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long applyEmpId;

    @ApiModelProperty("申请日期")
    @NotNull
    LocalDateTime applyDate;

    @ApiModelProperty("申请描述")
    String applyDesc;

    @ApiModelProperty("交易日期 实际出入库日期")
    LocalDateTime ioDate;

    @ApiModelProperty("从公司ID")
    @NotNull
    @JsonSerialize(using = ToStringSerializer.class)
    Long oOuId;

    @ApiModelProperty("从公司编码")
    String oOuCode;

    @ApiModelProperty("从仓库ID")
    @NotNull
    @JsonSerialize(using = ToStringSerializer.class)
    Long oWhId;
    String oWhCode;
    String oWhName;

    @ApiModelProperty("从温层 [UDC]INV:TEMP_TYPE")
    @SysCode(sys = "yst-inv", mod = "TEMP_TYPE")
    String oDeter1;
    String oDeter1Name;

    @ApiModelProperty("从功能区 [UDC]INV:FUNC_TYPE")
    @NotNull
    @SysCode(sys = "yst-inv", mod = "FUNC_TYPE")
    String oDeter2;
    String oDeter2Name;

    @ApiModelProperty("在途功能区[UDC]INV:FUNC_TYPE")
    @SysCode(sys = "yst-inv",mod = "FUNC_TYPE")
    String tranDeter3;
    String tranDeter3Name;

    @ApiModelProperty("从客户标识")
    String oDeter3;

    @ApiModelProperty("从限定4")
    String oDeter4;


    @ApiModelProperty("到公司ID")
    @NotNull
    @JsonSerialize(using = ToStringSerializer.class)
    Long iOuId;

    @ApiModelProperty("到公司编码")
    String iOuCode;

    @ApiModelProperty("到仓库ID")
    @NotNull
    @JsonSerialize(using = ToStringSerializer.class)
    Long iWhId;
    String iWhCode;
    String iWhName;

    @ApiModelProperty("到温层 [UDC]INV:TEMP_TYPE")
    @SysCode(sys = "yst-inv", mod = "TEMP_TYPE")
    String iDeter1;
    String iDeter1Name;

    @ApiModelProperty("到功能区 [UDC]INV:FUNC_TYPE")
    @NotNull
    @SysCode(sys = "yst-inv", mod = "FUNC_TYPE")
    String iDeter2;
    String iDeter2Name;

    @ApiModelProperty("到客户标识")
    String iDeter3;

    @ApiModelProperty("到限定4")
    String iDeter4;

    @ApiModelProperty("关联单据类别 如RMA。[UDC]COM:DOC_CLS")
    @SysCode(sys = "yst-supp", mod = "DOC_CLS")
    String relateDocCls;
    String relateDocClsName;

    @ApiModelProperty("关联单据类型")
    String relateDocType;

    @ApiModelProperty("关联单据ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long relateDocId;

    @ApiModelProperty("关联单据编号")
    String relateDocNo;

    @ApiModelProperty("关联ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long relateId;

    @ApiModelProperty("关联编号")
    String relateNo;

    @ApiModelProperty("关联2ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long relate2Id;

    @ApiModelProperty("关联2编号")
    String relate2No;

    @ApiModelProperty("原因码 [UDC]COM:REASON_CODE")
    @NotNull
    String reasonCode;

    @ApiModelProperty("是否走接口")
    Integer intfFlag;

    @ApiModelProperty(value = "租户ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long tenantId;

    @ApiModelProperty(value = "备注")
    private String remark;

    @CreatedBy
    @JsonSerialize(using = ToStringSerializer.class)
    private Long createUserId;

    @CreatedDate
    private LocalDateTime createTime;

    @LastModifiedBy
    @JsonSerialize(using = ToStringSerializer.class)
    private Long modifyUserId;

    @LastModifiedDate
    private LocalDateTime modifyTime;

    @ApiModelProperty(value = "版本")
    private Integer auditDataVersion;

    @ApiModelProperty("创建人名")
    private String creator;

    @ApiModelProperty("部门id")
    @JsonSerialize(using = ToStringSerializer.class)
    Long buId;

    @ApiModelProperty("单据类别")
    private String docCls;

    @ApiModelProperty("转移单明细")
    List<InvTrnDetail> details;

    @Data
    public static class InvTrnDetail implements Serializable {
        private static final long serialVersionUID = -8342040474280563355L;

        @ApiModelProperty("主表ID")
        @JsonSerialize(using = ToStringSerializer.class)
        Long masId;

        @ApiModelProperty("行号")
        Float lineNo;

        @ApiModelProperty("行状态")
        String lineStatus;

        @ApiModelProperty("行类型")
        String lineType;

        @ApiModelProperty("从公司ID")
        @JsonSerialize(using = ToStringSerializer.class)
        Long oOuId;

        @ApiModelProperty("从仓库ID")
        @JsonSerialize(using = ToStringSerializer.class)
        Long oWhId;

        @ApiModelProperty("从仓库code")
        String oWhCode;

        @ApiModelProperty("从温层 [UDC]INV:TEMP_TYPE")
        String oDeter1;

        @ApiModelProperty("从功能区 [UDC]INV:FUNC_TYPE")
        @NotNull
        String oDeter2;

        @ApiModelProperty("在途功能区[UDC]INV:FUNC_TYPE")
        String tranDeter3;
        String tranDeter3Name;

        @ApiModelProperty("从客户标识")
        String oDeter3;

        @ApiModelProperty("从限定4")
        String oDeter4;


        @ApiModelProperty("到公司ID")
        @JsonSerialize(using = ToStringSerializer.class)
        Long iOuId;

        @ApiModelProperty("到仓库ID")
        @JsonSerialize(using = ToStringSerializer.class)
        Long iWhId;

        @ApiModelProperty("到仓库code")
        String iWhCode;

        @ApiModelProperty("到温层 [UDC]INV:TEMP_TYPE")
        String iDeter1;

        @ApiModelProperty("到功能区 [UDC]INV:FUNC_TYPE")
        @NotNull
        String iDeter2;

        @ApiModelProperty("到客户标识")
        String iDeter3;

        @ApiModelProperty("到限定4")
        String iDeter4;

        @ApiModelProperty("品项ID")
        @NotNull
        @JsonSerialize(using = ToStringSerializer.class)
        Long itemId;

        @ApiModelProperty("异构ID")
        @JsonSerialize(using = ToStringSerializer.class)
        Long variId;

        @ApiModelProperty("批次")
        String lotNo;

        @ApiModelProperty("序列号")
        String snNo;

        @ApiModelProperty("单位")
        String uom;

        @ApiModelProperty("单位转换率")
        Float uomRatio;

        @ApiModelProperty("总数量")
        @NotNull
        BigDecimal qty;

        @ApiModelProperty("从包")
        String olimit1;

        @ApiModelProperty("到包")
        String ilimit1;

        @ApiModelProperty("成本金额")
        BigDecimal costAmt;

        @ApiModelProperty("关联单据类别 如RMA。[UDC]COM:DOC_CLS")
        @SysCode(sys = "yst-supp", mod = "DOC_CLS")
        String relateDocCls;
        String relateDocClsName;

        @ApiModelProperty("关联单据类型")
        String relateDocType;

        @ApiModelProperty("关联单据ID")
        @JsonSerialize(using = ToStringSerializer.class)
        Long relateDocId;

        @ApiModelProperty("关联单据编号")
        String relateDocNo;

        @ApiModelProperty("关联单据明细ID")
        @JsonSerialize(using = ToStringSerializer.class)
        Long relateDocDid;

        @ApiModelProperty("关联单据行号")
        Float relateDocLineno;

        @ApiModelProperty("从合作伙伴类型")
        String oPType;

        @ApiModelProperty("从合作伙伴编码")
        String oPCode;
        String oPName;

        @ApiModelProperty("至合作伙伴类型")
        String iPType;

        @ApiModelProperty("至合作伙伴编码")
        String iPCode;
        String iPName;
    }
}
