package com.elitesland.inv.dto.invstk;


import com.elitesland.inv.util.BaseModelDTO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 库存结存明细(InvStk)实体类
 * </p>
 *
 * @author jeesie.jiang
 * @since 2021-06-1 14:00:47
 */
@Data
@EqualsAndHashCode(callSuper=false)
@ApiModel(value = "invStkRpcDto", description = "库存结存明细")
public class InvStkRpcDTO extends BaseModelDTO implements Serializable {

    private static final long serialVersionUID = -8146401205963580511L;
    /**
     * 唯一编号ID
     */
    @ApiModelProperty("唯一编号ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;
    /**
     * 公司ID
     */
    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;
    /**
     * BUID
     */
    @ApiModelProperty("BUID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;
    /**
     * 品项ID
     */
    @ApiModelProperty("品项ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;
    /**
     * 异构ID
     */
    @ApiModelProperty("异构ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long variId;
    /**
     * 品项编号
     */
    @ApiModelProperty("品项编号")
    private String itemCode;

    @ApiModelProperty("品类")
    private String itemCateCode;

    @ApiModelProperty("品牌")
    private String brand;

    @ApiModelProperty("品项名")
    private String itemName;

    @ApiModelProperty("规格")
    private String spec;

    /**
     * 仓库ID
     */
    @ApiModelProperty("仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;

    @ApiModelProperty("仓库编码")
    private String whCode;

    @ApiModelProperty("仓库名")
    private String whName;

    /**
     * 温层 [UDC]INV:TEMP_TYPE
     */
    @ApiModelProperty("温层 [UDC]INV:TEMP_TYPE")
    private String deter1;
    /**
     * 功能区 [UDC]INV:FUNC_TYPE
     */
    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    private String deter2;
    private String deter2Name;

    @ApiModelProperty("功能区类型")
    private String deter2Type;
    /**
     * 客户标识
     */
    @ApiModelProperty("客户标识")
    private String deter3;
    /**
     * 限定4
     */
    @ApiModelProperty("限定4")
    private String deter4;
    /**
     * 限定5
     */
    @ApiModelProperty("限定5")
    private String deter5;
    /**
     * 限定6
     */
    @ApiModelProperty("限定6")
    private String deter6;
    /**
     * 限定7
     */
    @ApiModelProperty("限定7")
    private String deter7;
    /**
     * 限定8
     */
    @ApiModelProperty("限定8")
    private String deter8;
    /**
     * 库位
     */
    @ApiModelProperty("库位")
    private String whLoc;
    /**
     * 货位
     */
    @ApiModelProperty("货位")
    private String whPosi;
    /**
     * 批次号
     */
    @ApiModelProperty("批次号")
    private String lotNo;
    /**
     * 序列号
     */
    @ApiModelProperty("序列号")
    private String snNo;
    /**
     * 入库日期
     */
    @ApiModelProperty("入库日期")
    private LocalDateTime inDate;

    /**
     * 单位
     */
    @ApiModelProperty("单位")
    private String uom;
    /**
     * 单位2
     */
    @ApiModelProperty("单位2")
    private String uom2;
    /**
     * 单位转换率
     */
    private BigDecimal uomRatio;
    /**
     * 单位转换率2
     */
    @ApiModelProperty("单位转换率2")
    private Double uomRatio2;

    /**
     * 可用量
     */
    @ApiModelProperty("可用量")
    private BigDecimal avalQty;

    /**
     * ES1
     */
    @ApiModelProperty("ES1")
    private String es1;
    /**
     * ES2
     */
    @ApiModelProperty("ES2")
    private String es2;
    /**
     * ES3
     */
    @ApiModelProperty("ES3")
    private String es3;
    /**
     * ES4
     */
    @ApiModelProperty("ES4")
    private String es4;
    /**
     * ES5
     */
    @ApiModelProperty("ES5")
    private String es5;

    @ApiModelProperty("库存合作伙伴")
    private String pCode;

    @ApiModelProperty("库存合作伙伴类型")
    private String pType;

    @ApiModelProperty("库存合作伙伴名称")
    private String pName;

    @ApiModelProperty("公司编号")
    private String ouCode;
    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("limit1")
    private String limit1;

    @ApiModelProperty("limit2")
    private String limit2;

    @ApiModelProperty("limit3")
    private String limit3;

    @ApiModelProperty("生产日期")
    private LocalDateTime manuDate;

    @ApiModelProperty("失效日期")
    private LocalDateTime expireDate;

    @ApiModelProperty("仓库优先即")
    private Integer priority;

    @ApiModelProperty("保质期天数")
    private Integer expireDays;

    @ApiModelProperty("是否越库仓")
    private Boolean crossFlag;

    @ApiModelProperty("商品批次汇总库存量")
    private BigDecimal itmQty;

}
