package com.elitesland.inv.provider;


import com.elitesland.inv.Application;
import com.elitesland.inv.dto.invstk.*;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @author jeesie.jiang
 * @date 2022/05/08
 * <p>
 *  库存查询接口
 * </p>
 */
@Validated
@FeignClient(name = Application.NAME,path = Application.PATH + InvStkProvider.PATH)
public interface InvStkProvider {

    String PATH = "/invStk";
    /**
     * 根据条件查询库存
     */
    @PostMapping("/findInvStkRpcDto")
    ApiResult<List<InvStkRpcDTO>> findInvStkRpcDtoByParam(@RequestBody InvStkAllRpcDtoParam invStkAllRpcDtoParam);

    /**
     * 根据条件查询唯一库存
     */
    @PostMapping("/getInvStk")
    ApiResult<InvStkRpcDTO> getInvStk(@RequestBody InvStkRpcDtoParam param);

    @PostMapping("/getItemInvStk")
    List<ItmInvStkItemRpcDTO> getItemInvStk(@RequestBody InvStkItemRpcDtoParam param);

    /**
     * 分页查询批次库存
     * @param param
     * @return
     */
    @PostMapping("/searchLotPaging")
    PagingVO<InvStkDRpcDTO> searchLotPaging(@RequestBody InvStkDRpcDtoParam param);

    @PostMapping("/searchPaging")
    PagingVO<InvStkGroupRpcDTO> searchPaging(@RequestBody InvStkAllRpcDtoParam param);

}
