package com.elitesland.inv.provider;

import com.elitesland.inv.Application;
import com.elitesland.inv.dto.qt.InvQtSaveRpcParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;

/**
 * 质检单
 *
 * @author chaofeng.xia
 * @date 2024/7/10 11:35
 */
@Validated
@FeignClient(name = Application.NAME,path = Application.PATH + InvQtProvider.PATH)
public interface InvQtProvider {

    String PATH = "/invQt";

    /**
     * 生成入库质检单
     * @param createParam 质检单信息
     * @return 质检单编码
     */
    @PostMapping("/saveInvQt")
    String generate(InvQtSaveRpcParam createParam);
}
