package com.elitesland.inv.dto.invTro;

import com.alibaba.fastjson.serializer.ToStringSerializer;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@Data
@ApiModel(description = "调拨订单在线支付返回")
public class InvTroOnlinePayRpcDTO implements Serializable {
    private static final long serialVersionUID = 402129355488680789L;

    @ApiModelProperty("调拨订单订单ID")
    private Long troId;

    @ApiModelProperty("调拨订单号")
    private String troNo;

    @ApiModelProperty("在线支付单号")
    private String onlinePayOrderNo;

    @ApiModelProperty("在线支付时间")
    private LocalDateTime onlinePayTime;

    @ApiModelProperty("在线支付金额")
    private BigDecimal onlinePayAmt;

    @ApiModelProperty("在线支付标识")
    private Boolean onlinePayFlag;

    private List<TroItem> items;

    @Data
    public static class TroItem implements Serializable {

        private static final long serialVersionUID = 4817802496174323675L;

        @ApiModelProperty(value = "商品id")
        private Long itemId;

        @ApiModelProperty(value = "商品编码")
        private String itemCode;

        @ApiModelProperty(value = "商品名称")
        private String itemName;

        @ApiModelProperty(value = "订货数量")
        private BigDecimal troQty2;

        @ApiModelProperty("销售含税金额")
        private BigDecimal lastPathSaleAmt;

    }
}
